 @extends('admin.layout.adminmaster')

@section('contentarea')
<div class="mb-4">
    <h4>Booking Request Detail</h4>
    <div class="card">
        <div class="card-body">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>S.No</th>
                        <th>Name</th>
                        <th>Mobile</th>
                        <th>From Place</th>
                        <th>To Place</th>
                        <th>Car Type</th>
                        <th>Pickup Date</th>
                        <th>Pickup Time</th>
                        <th>Message</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>1</td>
                        <td>{{ $getRow->name }}</td>
                        <td>{{ $getRow->mobile }}</td>
                        <td>{{ $getRow->from_place }}</td>
                        <td>{{ $getRow->to_place }}</td>
                        <td>{{ $getRow->car_type }}</td>
                        <td>{{ \Carbon\Carbon::parse($getRow->pickup_date)->format('d M Y') }}</td>
                        <td>{{ \Carbon\Carbon::parse($getRow->pickup_time)->format('h:i A') }}</td>
                        <td>{{ $getRow->message }}</td>
                        <td>
                            <a href="{{ route('admin.ContactusManagement-index') }}" class="btn btn-sm btn-dark">Back</a>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

 


 