<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Driver Report PDF</title>
    <style>
        body {
            font-family: sans-serif;
        }
        h2 {
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 14px;
        }
        th, td {
            padding: 8px 10px;
            border: 1px solid #000;
            text-align: left;
        }
        th {
            background-color: #f1f1f1;
        }
    </style>
</head>
<body>

    <h2>Driver Payment Report</h2>
    @if($sfrom_date && $sto_date)
        <p><strong>From:</strong> {{ $sfrom_date }} &nbsp;&nbsp; <strong>To:</strong> {{ $sto_date }}</p>
    @endif

    <table>
        <thead class="table-dark">
            <tr>
                <th>Date</th>
                <th>Driver Details</th>
                <th>Driver Earning Amount</th>
                <th>Commission Amount (Rs.)</th>
                <th>Paid Amount (Rs.)</th>
                <th>Balance Amount (Rs.) </th>
                <th>Status </th>
            </tr>
        </thead>
        <tbody>
            @forelse ($datas as $data)
            <tr>
                <td>{{ \Carbon\Carbon::parse($data->trip_date)->format('d M, Y')}}</td>
                <td>{{ $data->driver_code}}</td>
                <td>Rs. {{ number_format($data->amount, 2) }}</td>
                <td>Rs. {{ number_format($data->commission_amount, 2) }}</td>
                <td>Rs. {{ number_format($data->paid_amount, 2) }}</td>
                <td>Rs. {{ number_format($data->pending_amount, 2) }}</td>
                <td>
                    @if ($data->payment_status == 0)
                    <span class="badge bg-danger">Unpaid</span>
                    @elseif ($data->payment_status == 1)
                    <span class="badge bg-warning text-dark">Pending</span>
                    @elseif ($data->payment_status == 2)
                    <span class="badge bg-success">Paid</span>
                    @else
                    <span class="badge bg-secondary">Unknown</span>
                    @endif
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="5" class="text-center text-muted">No data available for the selected filters.</td>
            </tr>
            @endforelse

        </tbody>
    </table>

</body>
</html>
