@extends('admin.layout.adminmaster')

@section('style1')
<style>
.searcharea > div {
    padding-right:10px;
}
</style>
@endsection

@section('contentarea')
<div class="container mt-4">

    <h2 class="mb-4">Payment Management</h2>

    <form method="post" action="{{ route('admin.PaymentManagement-index') }}" id="myForm" class="row g-3 mb-4">
        @method('post')
        @csrf
        <input type="hidden" name="action_type" id="action_type" value="0">

        <div class="col-md-12 searcharea" style="display: flex">
            <div>
                <label for="from_date" class="form-label">From Date</label>
                <input type="text" id="from_date" name="from_date" value="{{ $sfrom_date ?? "" }}" class="form-control"
                    readonly>
            </div>
            <div>
                <label for="to_date" class="form-label">To Date</label>
                <input type="text" id="to_date" name="to_date" value="{{ $sto_date ?? "" }}" class="form-control"
                    readonly>
            </div>

            <div><label for="driver_name" class="form-label">Driver Name / Id</label>
                <select id="driver_name" name="driver_name">
                    <option value="0" @if($sdriver_name=="0" ) selected @endif>All</option>
                    @foreach ($driverList as $driverRow)
                    <option value="{{ $driverRow->id }}" @if($sdriver_name==$driverRow->id) selected @endif>{{
                        $driverRow->driver_code }} - {{ $driverRow->driver_name }}</option>
                    @endforeach
                </select>
            </div>
            <div><label for="status1" class="form-label">Payment Status</label>
                <select id="status1" name="status1" class="form-select">
                    <option value="all" {{ isset($sstatus1) && $sstatus1=='all' || request('status')==null ? 'selected'
                        : '' }}>All
                    </option>
                    <option value="paid" {{ isset($sstatus1) && $sstatus1=='paid' ? 'selected' : '' }}>Paid</option>
                    <option value="unpaid" {{ isset($sstatus1) && $sstatus1=='unpaid' ? 'selected' : '' }}>Unpaid
                    </option>
                    <option value="partially_paid" {{ isset($sstatus1) && $sstatus1=='partially_paid' ? 'selected' : ''
                        }}>Pending
                    </option>
                </select>
            </div>
            <div><button type="button" class="submit-btn btn btn-primary" data-action="search"
                    style="margin-top:30px;">Search</button>
                <button type="button" class="submit-btn btn btn-secondary ms-2" data-action="clear"
                    style="margin-top:30px;">Clear</button>
                <a
            href="{{ route('admin.PaymentManagement-index', array_merge(request()->all(), ['download' => 'pdf'])) }}"
            class="btn btn-danger ms-2" style="margin-top:30px;">Download PDF</a>
            <a href="{{ route('admin.PaymentManagement-create') }}" class="btn btn-success" style="margin-top:30px;">Add New Payment</a>
            </div>

        </div>
        <div class="col-md-2">

        </div>
        <div class="col-md-4">

            {{-- <input type="text" value="{{ $sdriver_name ?? "" }}" class="form-control" placeholder="Search name">
            --}}
        </div>

        <div class="col-md-2">

        </div>


        <div class="col-md-4">



        </div>
    </form>
    <div class="col-md-12 align-self-end" style="margin-bottom: 10px;">


        {{-- <button type="button" class="submit-btn" data-action="reject">Download PDF</button>
        <button type="button" class="submit-btn" data-action="delete">Delete</button> --}}

        {{-- <button type="submit" class="btn btn-primary">Search</button>
        <a href="{{ route('admin.PaymentManagement-index') }}" class="btn btn-secondary ms-2">Clear</a> --}}
        {{-- <a
            href="{{ route('admin.PaymentManagement-index', array_merge(request()->all(), ['download' => 'pdf'])) }}"
            class="btn btn-danger ms-2">Download PDF</a>
        <a href="{{ route('admin.PaymentManagement-create') }}" class="btn btn-success">Add New Payment</a> --}}
    </div>
    <div class="table-responsive">
        <table id="payment-table" class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>Driver Details</th>
                    <th>Driver Earning Amount</th>
                    <th>Commission Amount </th>
                    <th>Paid Amount </th>
                    <th>Balance Amount </th>
                    <th>Status </th>
                </tr>
            </thead>
            <tbody>
                @forelse ($datas as $data)
                <tr>
      				<td>{{ \Carbon\Carbon::parse($data->created_at)->format('d M Y') . ' - ' . $data->driver_code . '-' . $data->driver_name   }}</td>
                    <td>₹ {{ number_format($data->amount, 2) }}</td>
                    <td>₹ {{ number_format($data->commission_amount, 2) }}</td>
                    <td>₹ {{ number_format($data->paid_amount, 2) }}</td>
                    <td>₹ {{ number_format($data->pending_amount, 2) }}</td>
                    <td>
                        @if ($data->payment_status == 0)
                        <span class="badge bg-danger">Unpaid</span>
                        @elseif ($data->payment_status == 1)
                        <span class="badge bg-warning text-dark">Pending</span>
                        @elseif ($data->payment_status == 2)
                        <span class="badge bg-success">Paid</span>
                        @else
                        <span class="badge bg-secondary">Unknown</span>
                        @endif
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" class="text-center text-muted">No data available for the selected filters.</td>
                </tr>
                @endforelse

            </tbody>
        </table>
    </div>

</div>
@endsection

@section('script2')
<script>
    $(document).ready(function(){
        $('.submit-btn').click(function () {
        var actionType = $(this).data('action'); // Get button data-action value
        $('#action_type').val(actionType);       // Set hidden input value
        $('#myForm').submit();                   // Submit the form
    });


    $('#driver_name').select2({
    placeholder: "Select User Roles",
    allowClear: false,
    });



    $('#from_date').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        todayHighlight: true
    });

    $('#to_date').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        todayHighlight: true
    });

    // When from_date changes
    $('#from_date').on('changeDate', function () {
        const fromDate = $('#from_date').datepicker('getDate');
        const toDate = $('#to_date').datepicker('getDate');

        // Set the minimum selectable date for to_date
        $('#to_date').datepicker('setStartDate', fromDate);

        // If to_date is before from_date, update to_date to match from_date
        if (toDate && toDate < fromDate) {
            $('#to_date').datepicker('setDate', fromDate);
        }
    });

    // When to_date changes
    $('#to_date').on('changeDate', function () {
        const fromDate = $('#from_date').datepicker('getDate');
        const toDate = $('#to_date').datepicker('getDate');

        // If to_date is before from_date, update from_date to match to_date
        if (fromDate && toDate && toDate < fromDate) {
            $('#from_date').datepicker('setDate', toDate);
            $('#to_date').datepicker('setStartDate', toDate); // update min of to_date
        }
    });
});
</script>
@endsection