@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container mt-4">

    <h2 class="mb-4">Driver Report</h2>

    <form method="GET" action="{{ route('admin.DriverReport-index') }}" class="row g-3 mb-4">
        <div class="col-md-3">
            <label for="from_date" class="form-label">From Date</label>
            <input type="date" id="from_date" name="from_date" value="{{ request('from_date') }}" class="form-control">
        </div>
        <div class="col-md-3">
            <label for="to_date" class="form-label">To Date</label>
            <input type="date" id="to_date" name="to_date" value="{{ request('to_date') }}" class="form-control">
        </div>
        <div class="col-md-3 align-self-end">
            <button type="submit" class="btn btn-primary">Search</button>
            <a href="{{ route('admin.DriverReport-index') }}" class="btn btn-secondary ms-2">Clear</a>
        <a href="{{ route('admin.DriverReport-index', array_merge(request()->all(), ['download' => 'pdf'])) }}" class="btn btn-danger ms-2">Download PDF</a>        </div>
    </form>

 <div class="table-responsive">
    <table class="table table-bordered table-striped align-middle">
        <thead class="table-dark">
            <tr>
                <th>Driver ID</th>
                <th>Driver Name</th>
                <th>Opening KM</th>
                <th>Closing KM</th>
                <th>Total Amount (₹)</th>
                <th>Trip Dates</th>
           <!-- <th>Action</th> -->
            </tr>
        </thead>
        <tbody>
          @forelse ($bookings as $booking)
        <tr>
        <td>{{ $booking->driver_id }}</td>
        <td>{{ $booking->driver_name }}</td>
        <td>{{ $booking->start_km }}</td>
        <td>{{ $booking->end_km }}</td>
        <td>₹{{ number_format($booking->total_price, 2) }}</td>
        <td>{{ $booking->trip_date ? \Carbon\Carbon::parse($booking->trip_date)->format('d-m-Y') : '-' }}</td>
         <!-- <td>
            <form action="{{ route('admin.DriverReport-recalculate', ['driver_id' => $booking->driver_id]) }}" method="POST">
                @csrf
                <input type="hidden" name="trip_date" value="{{ $booking->trip_date }}">
                <button type="submit" class="btn btn-warning btn-sm">Recalculate</button>
            </form>
        </td> -->
    </tr>
@empty
    <tr>
        <td colspan="7" class="text-center text-muted">No data available for the selected filters.</td>
    </tr>
@endforelse
        </tbody>
    </table>
</div>


</div>
@endsection

