<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Driver Report PDF</title>
    <style>
        body {
            font-family: sans-serif;
        }
        h2 {
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            font-size: 14px;
        }
        th, td {
            padding: 8px 10px;
            border: 1px solid #000;
            text-align: left;
        }
        th {
            background-color: #f1f1f1;
        }
    </style>
</head>
<body>

    <h2>Driver Report</h2>
    @if($from_date && $to_date)
        <p><strong>From:</strong> {{ $from_date }} &nbsp;&nbsp; <strong>To:</strong> {{ $to_date }}</p>
    @endif

    <table>
        <thead>
            <tr>
                <th>Driver Name</th>
                <th>Total Trips</th>
                <th>Total Amount (RS)</th>
            </tr>
        </thead>
        <tbody>
            @foreach($driverReports as $report)
                <tr>
                    <td>{{ $report['driver_name'] }}</td>
                    <td>{{ $report['trip_count'] }}</td>
                    <td>Rs. {{ number_format($report['total_amount'], 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

</body>
</html>
