@@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container mt-4">

    <h2 class="mb-4">Recalculated Payment Summary</h2>

    <div class="card">
        <div class="card-body">
            <table class="table table-bordered">
                <tbody>
                    <tr>
                        <th>Driver ID</th>
                        <td>{{ $summary['driver_id'] }}</td>
                    </tr>
                    <tr>
                        <th>Opening KM</th>
                        <td>{{ $summary['opening_km'] }}</td>
                    </tr>
                    <tr>
                        <th>Closing KM</th>
                        <td>{{ $summary['closing_km'] }}</td>
                    </tr>
                    <tr>
                        <th>Total KM Travelled</th>
                        <td>{{ $summary['total_km_travelled'] }}</td>
                    </tr>
                    <tr>
                        <th>Trip Type (Indoor/Outdoor)</th>
                        <td>{{ ucfirst($summary['indoor_outdoor']) }}</td>
                    </tr>
                    <tr>
                        <th>Hill KM</th>
                        <td>{{ $summary['hill_km'] }}</td>
                    </tr>
                    <tr>
                        <th>Base Fare</th>
                        <td>₹ {{ number_format($summary['base_fare'] ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <th>Distance Fare</th>
                        <td>₹ {{ number_format($summary['distance_fare'] ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <th>Hourly Fare</th>
                        <td>₹ {{ number_format($summary['hr_fare'] ?? 0, 2) }}</td>
                    </tr>
                    <tr>
                        <th>Waiting Charge</th>
                        <td>₹ {{ number_format($summary['waiting_charge'], 2) }}</td>
                    </tr>
                    <tr>
                        <th>Night Fare</th>
                        <td>₹ {{ number_format($summary['nightfair_amount'], 2) }}</td>
                    </tr>
                    <tr>
                        <th>Total Fare (Before Extra)</th>
                        <td>₹ {{ number_format($summary['total_price'], 2) }}</td>
                    </tr>
                    <tr>
                        <th>Extra Fare</th>
                        <td>₹ {{ number_format($summary['extra_fair'], 2) }}</td>
                    </tr>
                    <tr>
                        <th>Discount</th>
                        <td>- ₹ {{ number_format($summary['extra_discountamount'], 2) }}</td>
                    </tr>
                    <tr class="table-success">
                        <th><strong>Final Recalculated Amount</strong></th>
                        <td><strong>₹ {{ number_format($summary['recalculate_finalamount'], 2) }}</strong></td>
                    </tr>
                </tbody>
            </table>

            <a href="{{ route('admin.DriverReport-index') }}" class="btn btn-secondary mt-3">Back to Report</a>
        </div>
    </div>

</div>
@endsection

