@extends('admin.layout.adminmaster')

@section('style1')



<style>
    .containerbutton {
        display: flex;
        justify-content: flex-end;
        /* Aligns button to the right */
        margin-bottom: 10px;
        /* Optional: Space between button and table */
    }

    .header-container {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }




    .tblsearch {
        width: 100%;
        margin: 4px auto 0px auto;
        height: 30px;
        padding-left: 6px;
    }

    a {
        color: #5b5959;
    }

    .text-wrap {
        white-space: normal !important;
        word-break: break-word;
        max-width: 200px;
        /* adjust as needed */
    }

    .row-warning-dark {
        background-color: #5a4300 !important;
        /* dark yellowish brown */
        color: #fff;
    }

    .row-danger-dark {
        background-color: #6b0000 !important;
        /* dark red */
        color: #fff;
    }

    .row-success-dark {
        background-color: #014d1f !important;
        /* dark green */
        color: #fff;
    }

    #listAjaxDataTable .row-success-dark {
        color :#fff !important;
    }
</style>

@endsection











@section('contentarea')

<h4>Booking Management</h4>

<div class="row">
    <div class="header-container">

        <div class="col-xl-8">
            <div class="typeahead__container mb-1">

                <div class="row align-items-end mb-2">
                    <div class="col-md-3">
                        <div class="typeahead__field">
                            <label for="customsearch" class="form-label d-none d-md-block">&nbsp;</label>
                            <input class="form-control customsearch" id="customsearch" placeholder="Search DriverName"
                                autocomplete="off">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label for="from_date">From Date</label>
                        <input type="date" id="from_date" alue="{{ $from_date ?? "" }}" class="form-control" />
                    </div>
                    <div class="col-md-3">
                        <label for="to_date">To Date</label>
                        <input type="date" id="to_date" alue="{{ $to_date ?? "" }}" class="form-control" />
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button class="btn btn-primary" id="filterDateBtn">Filter</button>
                        <button class="btn btn-secondary ms-2" id="resetDateBtn">Reset</button>
                    </div>



                </div>
            </div>
        </div>

        <div class="containerbutton">
            <a href="{{route('admin.BookingManagement-create') }}" class="btn btn-warning">New Booking</a>
        </div>
    </div>
</div>



<table id="listAjaxDataTable" class="table text-nowrap w-100  mb-3">
    <thead>
        <tr>
            <th data-ftcol="sno"> S.No </th>
            <th data-ftcol="booking_date">Booking Date</th>
            <th data-ftcol="DriverName">Driver Name</th>
            <th data-ftcol="customer_name">Customer Name /<br> Number</th>
            <th data-ftcol="from_address">From Address</th>
            {{-- <th data-ftcol="start_image">Start Image</th> --}}
            <th data-ftcol="to_address">To Address</th>
            <th data-ftcol="otp">OTP</th>
            <th data-ftcol="actions"> Action </th>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>







@endsection

@section('script1')


<script src="{{ asset('public/admin_assets/js/jquery.min.js') }}"></script>




<script>
    $(document).ready(function() {

        function formatDateToDMY(dateStr) {
    if (!dateStr) return '';

    const dateObj = new Date(dateStr);
    if (isNaN(dateObj.getTime())) return '';

    const day = dateObj.getDate().toString().padStart(2, '0');
    const monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
                        "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    const month = monthNames[dateObj.getMonth()];
    const year = dateObj.getFullYear();

    return `${day} ${month} ${year}`;
}

        function formatTimeToAMPM(timeStr) {
    if (!timeStr) return '';

    // If timeStr is "HH:mm:ss" or "YYYY-MM-DD HH:mm:ss"
    let dateObj = new Date(timeStr);

    // Fallback if parsing fails (like if only "HH:mm:ss")
    if (isNaN(dateObj.getTime()) && /^\d{2}:\d{2}(:\d{2})?$/.test(timeStr)) {
        const parts = timeStr.split(':');
        let hours = parseInt(parts[0], 10);
        const minutes = parseInt(parts[1], 10);
        const ampm = hours >= 12 ? 'PM' : 'AM';
        hours = hours % 12 || 12;
        return `${hours}:${minutes.toString().padStart(2, '0')} ${ampm}`;
    }

    if (isNaN(dateObj.getTime())) return '';

    let hours = dateObj.getHours();
    let minutes = dateObj.getMinutes();
    const ampm = hours >= 12 ? 'PM' : 'AM';
    hours = hours % 12 || 12;
    return `${hours}:${minutes.toString().padStart(2, '0')} ${ampm}`;
}

            var reorderStart = -1; 
        $('th').on("click", function(event) {
            if ($(event.target).is("input") || $(event.target).is("select")) {
                event.stopImmediatePropagation();
            }
        });
        var sno = 1;
        var dataTablecol = [
            {
                "name": "serial_no",
                "searchable": false,
                "sortable": true,
                render: function(data, type, row, meta) {
                    return meta.row + meta.settings._iDisplayStart + 1;
                }
            },
            {
        "searchable": true,
        "sortable": false,
        data: 'booking_date',
        name: 'booking_date',
        render: function(data, type, row) {
                return formatDateToDMY(data) + '<br>'+formatTimeToAMPM(row.booking_time);
            }
        
    },

         {
                 "searchable": true,
                    "sortable": false,
                    data: 'DriverName',
                    name: 'driver_name',
                  render: function(data, type, row) {
                    return data ? row.DriverCode +'</br>'+row.DriverName : 'Not Accept';
                }
        },

          

            {
                    "searchable": true,
                    "sortable": false,
                    data: 'customer_name',
                    name: 'customer_name',
                    render: function(data, type, row) {
        var resulthtml = row.customer_name + '<br>'+ row.phone;

        return resulthtml;
    }


               },
            // {
            //         "searchable": true,
            //         "sortable": false,
            //         data: 'phone',
            //         name: 'customer_number',


            //    },
                
            {
                    "searchable": true,
                    "sortable": false,
                    data: 'from_address',
                    name: 'from_address',
                    className: 'text-wrap'


               },
            // {
            //         data: 'start_image',
            //         name: 'start_image',
            //         searchable: false,
            //         sortable: false,
            //       render: function (data, type, row) {
            //         if (data) {
            //             return `<img src="{{ asset('public/storage/') }}/${data}" alt="Driver Photo" width="60" height="60" class="rounded-circle">`;
            //         } else {
            //             return `<span class="text-muted">No Photo</span>`;
            //         }
            //     }

            //    },
            {
                    "searchable": true,
                    "sortable": false,
                    data: 'to_address',
                    name: 'to_address',
                    className: 'text-wrap'


               },
           {
    "searchable": true,
    "sortable": false,
    data: 'otp',
    name: 'otp',
    render: function(data, type, row) {
        var resendOtpBtn = '<a href="#" class="resendOtp" data-id="' + row.id + '" title="Resend OTP">' +
                           '<span style="color: green; font-weight: 500; text-decoration: underline;">Resend</span>' +
                           '</a>';

        return (data ? data : '') + '</br>' + resendOtpBtn;
    }
},



               

            // {
            //     data: 'status',
            //     name: 'status',
            //     searchable: true,
            //     orderable: false,
            //     render: function(data, type, row) {
            //     let checked = row.status == 1 ? 'checked' : '';
            //     return `
            //         <div class="form-check form-switch">
            //             <input type="checkbox" class="form-check-input status-toggle"
            //                    id="statusSwitch${row.id}" data-id="${row.id}" ${checked}>
            //             <label class="form-check-label" for="statusSwitch${row.id}">
            //                 ${row.status == 1 ? 'Active' : 'Inactive'}
            //             </label>
            //         </div>`;
            // }
            // },


            {
                "searchable": false,
                "sortable": false,
                data: 'id',
                render: function(data, type, row, meta) {
                    var url = "{{ route('admin.BookingManagement') }}";
                  

                    var editLink = '<a class="" href="' + url + '/' + data + '/edit" title="Edit">' +
                        '<i class="mdi mdi-account-edit" style="color: rgb(0, 157, 255); font-size: 20px"></i>' +
                        '</a>';

                        editLink = '';
                   
                    var viewLink = '<a class="" href="' + url + '/' + data + '/view" title="View">' +
                        '<i class="mdi mdi-eye" style="color: #009378; font-size: 20px"></i>' +
                        '</a>';

                    var cancelLink = '<a href="#" data-id="' + data + '" class="cancelRideBtn" title="Cancel Ride">' +
                        '<i class="mdi mdi-close-circle" style="color: orange; font-size: 20px;"></i>' +
                            '</a>';

                    if(row.booking_status==5 || row.booking_status==4)
                    {
                        cancelLink = "<span style='padding-left:20px'>&nbsp;</span>";
                    }
                    var deleteLink = '<a data-id="' + data + '" class="deleteRow" href="#" title="Delete">' +
                        '<i class="mdi mdi-delete" style="color: red; font-size: 20px;"></i>' +
                        '</a>';
                 var editLink1 = '';
                    if (row.driver_id && row.DriverName && row.DriverName !== 'Not Accept') {
                        editLink1 = '<a class="" href="' + url + '/' + data + '/edit1" title="Edit1">' +
                            '<i class="mdi mdi-note-edit" style="color: rgb(0, 157, 255); font-size: 20px"></i>' +
                            '</a>';
                    }


                    var result = editLink + '&nbsp;' + viewLink +  '&nbsp;' +cancelLink+'&nbsp;' + deleteLink +'&nbsp;' + editLink1;
                    return result;
                }
            },
            
        ];
        var listAjaxDataTable = $('#listAjaxDataTable').DataTable({
            // "order": [
            //     [0, "desc"]
            // ],
            "processing": true,
            "serverSide": true,
            "colReorder": true,
            "columns": dataTablecol,
            "ordering": false,
            "bAutoWidth": false,
            // "dom": 'ltpr',
            "dom": " <'row'<'col-sm-12 mt-3'tr>><'row'<'col-sm-2'l><'col-sm-6'i><'col-sm-4'p>>",
            "drawCallback": function(settings) {
                var response = settings.json;
                if (response.recordsTotal > 0) {
                    $('#exportreport').show();
                } else {
                    $('#exportreport').hide();
                }
            },
            "ajax": DataTable.pipeline({
                url: "{{ route('admin.BookingManagement-dataindex') }}",
                method: 'POST',
                data: function(d) {
                    d._token = '{{ csrf_token() }}';
                    d.from_date = $('#from_date').val();
                    d.to_date = $('#to_date').val();
                    
                },
                pages: 5 // number of pages to cache
            }),
            "createdRow": function(row, data, dataIndex) {


const isDark = document.body.classList.contains('dark-mode');
let currentTheme = document.documentElement.getAttribute('data-bs-theme');
// console.log('currentTheme',currentTheme);



        // If DriverName is null or "Not Accept", highlight the row
        if (!data.DriverName || data.DriverName === 'Not Accept') {
            if (currentTheme && currentTheme == 'dark') {
                $(row).addClass('row-warning-dark');
            } else {
                $(row).addClass('table-warning');
            }
        }

        // Example: Add red for cancelled status
        if (data.booking_status == '5') {
             if (currentTheme && currentTheme == 'dark') {
                $(row).addClass('row-danger-dark');
            } else {
                $(row).addClass('table-danger');
            }
        }
        console.log(data.DriverName,data.booking_status);
        // Example: Add green for completed bookings
        if (data.booking_status == '4') {
             if (currentTheme && currentTheme == 'dark') {
                $(row).addClass('row-success-dark');
            } else {
                $(row).addClass('table-success');
            }
        }
    }
        });
   $('#customsearch').on('keyup change', function () {
                let value = $(this).val();
                listAjaxDataTable.search(value).draw();
            });
            
$('#filterDateBtn').on('click', function () {
    console.log('Filter clicked');
    $('#listAjaxDataTable').DataTable().clearPipeline().draw();
});

$('#resetDateBtn').on('click', function () {
    $('#from_date').val('');
    $('#to_date').val('');
    $('#listAjaxDataTable').DataTable().clearPipeline().draw();
});

        $('table').on('click', '.deleteRow', function(e) {
            e.preventDefault();
            $chId = $(this).data('id');
            var k = confirm("Are you sure to Delete this record.");
            if (k == true) {
                $.ajax({
                    url: "{{ route('admin.BookingManagement') }}/" + $chId,
                    method: "DELETE",
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    error: function(data) {
                        toastr.error("Error Occured. Please Try Again Later.");
                    },
                    success: function(result) {
                        result = JSON.stringify(result)
                        result = JSON.parse(result);
                        if (result.status == 200) {
                            toastr.success("Deleted Successfully");
                            listAjaxDataTable.clearPipeline().draw();
                        } else {
                            toastr.error("Error Occured. Please Try Again Later.");
                        }
                    }
                });
            }
        });


        $(document).on('change', '.status-toggle', function () {
    let checkbox = $(this);
    let id = checkbox.data('id');
    let status = checkbox.is(':checked') ? 1 : 0;

    let message = status === 1 
        ? "Are you sure you want to activate this driver?" 
        : "Are you sure you want to deactivate this driver?";

    if (confirm(message)) {
        $.ajax({
            url: "{{ route('admin.vehicleupdate-status') }}",
            type: "POST",
            data: {
                _token: '{{ csrf_token() }}',
                id: id,
                status: status
            },
            success: function (response) {
                let label = checkbox.closest('.form-check').find('label');
                label.text(status === 1 ? 'Active' : 'Inactive');
                toastr.success(response.message || 'Status updated');

            },
            error: function () {
                toastr.error('Failed to update status');
                checkbox.prop('checked', !status); // rollback toggle on error
            }
        });
    } else {
        checkbox.prop('checked', !status); // rollback toggle if cancelled
    }
});

$(document).on('click', '.resendOtp', function(e) {
    e.preventDefault();
    var bookingId = $(this).data('id');

    if (confirm("Send OTP to driver via WhatsApp?")) {
        $.ajax({
            url: "{{ route('admin.Bookingsendotp') }}", // define this route
            type: "POST",
            data: {
                _token: '{{ csrf_token() }}',
                booking_id: bookingId
            },
            success: function(response) {
                if (response.status) {
                    toastr.success("OTP sent via WhatsApp");
                } else {
                    toastr.error(response.message || "Failed to send OTP");
                }
            },
            error: function() {
                toastr.error("Something went wrong. Try again.");
            }
        });
    }
});
$(document).on('click', '.cancelRideBtn', function(e) {
    e.preventDefault();
    var bookingId = $(this).data('id');

    var reason = prompt("Please enter the cancel reason:");

    if (reason === null || reason.trim() === "") {
        toastr.warning("Cancellation reason is required.");
        return;
    }

    if (confirm("Are you sure you want to cancel this ride?")) {
        $.ajax({
            url: "{{ route('admin.Bookingcancel') }}", // make sure this route exists
            type: "POST",
            data: {
                _token: '{{ csrf_token() }}',
                booking_id: bookingId,
                cancel_reason: reason
            },
            success: function(response) {
                if (response.status) {
                    toastr.success(response.message || "Ride cancelled successfully.");
                    listAjaxDataTable.clearPipeline().draw();
                } else {
                    toastr.error(response.message || "Failed to cancel ride.");
                }
            },
            error: function() {
                toastr.error("Something went wrong. Please try again.");
            }
        });
    }
});

setInterval(function () {
    $('#listAjaxDataTable tbody tr').each(function () {
        var rowElement = $(this);
        var rowData = $('#listAjaxDataTable').DataTable().row(rowElement).data();

        if (!rowData || !rowData.id) return;

        $.ajax({
            url: "{{ route('admin.BookingManagement.getRow') }}",
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                booking_id: rowData.id
            },
            success: function (response) {
                if (response.status) {
                    var updated = response.data;

                    // ✅ Update Driver Name with online status
                    var driverDisplay = updated.DriverName ? updated.DriverName : 'Not Accept';

                    rowElement.find('td:eq(2)').html(driverDisplay); // column index for DriverName

                    // ✅ Update OTP + Resend Button
                    var otpHtml = (updated.otp ? updated.otp : '') +
                        '</br><a href="#" class="resendOtp" data-id="' + rowData.id + '" title="Resend OTP">' +
                        '<span style="color: green; font-weight: 500; text-decoration: underline;">Resend</span>' +
                        '</a>';

                    rowElement.find('td:eq(6)').html(otpHtml); // column index for OTP
                }
            }
        });
    });
}, 10000); // runs every 10 seconds

       
        
        });
</script>

@endsection