@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="mb-4">
    <h4>Booking Details</h4>
    <div class="card">
        <div class="card-body">
            <table class="table table-bordered">
                <tbody>
                    <tr>
                        <th style="width: 30%;">Customer Name</th>
                        <td>{{ $getRow->customer_name ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Phone</th>
                        <td>{{ $getRow->phone ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                <th>Pickup Location</th>
                <td style="white-space: normal;">{{ $fare_summary->pickup_location ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Drop Location</th>
                <td style="white-space: normal;">{{ $fare_summary->drop_location ?? 'N/A' }}</td>
            </tr>
                    <tr>
                        <th>Notify Driver</th>
                        <td class="text-capitalize">{{ $getRow->notify_driver ?? 'N/A' }}</td>
                    </tr>
                    {{-- <tr>
                        <th>Trip Status</th>
                        <td>
                            <span class="badge {{ $getRow->trip_status ? 'bg-success' : 'bg-warning' }}">
                                {{ $getRow->trip_status ? 'Accepted' : 'Pending' }}
                            </span>
                        </td>
                    </tr> --}}
                    <tr>
                        <th>Assigned Driver</th>
                        <td>
                            @if($get_driver)
                                {{ $get_driver->driver_name }} ({{ $get_driver->user_name }})
                            @else
                                <em>No driver assigned</em>
                            @endif
                        </td>
                    </tr>
                  <tr>
             <th>Car Type</th>
            <td>{{ $getRow->cartype_name }}</td>
            </tr>
              <tr>
                <th>Start Date</th>
                <td>{{ $getRow->booking_date ?? 'N/A' }}</td>
            </tr>
             <tr>
                <th>End Date</th>
                <td>{{ $fare_summary->end_date ?? 'N/A' }}</td>
            </tr>
              <tr>
                <th>Start Time</th>
                <td>{{ $fare_summary->start_time ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>End Time</th>
                <td>{{ $fare_summary->end_time ?? 'N/A' }}</td>
            </tr>
             <tr>
                <th>Travel Minutes</th>
                <td>{{ $fare_summary->travel_minutes ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Total KM Travelled</th>
                <td>{{ $fare_summary->total_km_travelled ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Package KM</th>
                <td>{{ $fare_summary->package_km ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Extra KM Charged</th>
                <td>{{ $fare_summary->extra_km_charged ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Base Fare</th>
                <td>{{ $fare_summary->base_fare ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Per KM Charge</th>
                <td>{{ $fare_summary->per_km_charge ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Distance Fare</th>
                <td>{{ $fare_summary->distance_fare ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Hour Fare</th>
                <td>{{ $fare_summary->hr_fare ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Waiting Charge</th>
                <td>{{ $fare_summary->waiting_charge ?? 'N/A' }}</td>
            </tr>
            <tr>
                <th>Total Price</th>
                <td><strong>₹ {{ $fare_summary->total_price ?? 'N/A' }}</strong></td>
            </tr>
           
          
          
                    
                </tbody>
            </table>

            <div class="mt-4">
                <a href="{{ route('admin.BookingManagement-index') }}" class="btn btn-dark">
                    Back to List
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
