@extends('admin.layout.adminmaster')

@section('style1')

        

        <style>
            .containerbutton {
                display: flex;
                justify-content: flex-end;
                /* Aligns button to the right */
                margin-bottom: 10px;
                /* Optional: Space between button and table */
            }
            .header-container {
                        display: flex;
                        justify-content: space-between;
                        align-items: center;
                    }


            

            .tblsearch {
                width: 100%;
                margin: 4px auto 0px auto;
                height: 30px;
                padding-left: 6px;
            }

            a {
                color: #5b5959;
            }

            .text-wrap {
    white-space: normal !important;
    word-break: break-word;
    max-width: 200px; /* adjust as needed */
}
        </style>

@endsection


@section('contentarea')

<h4>Contactus Management</h4>

<div class="row">
    <div class="header-container">

<div class="col-xl-8">
    <div class="typeahead__container mb-1">

        {{-- <div class="typeahead__field">
            <div class="typeahead__query input-group">
                <input class="form-control customsearch" id="customsearch" placeholder="search here.."
                    autocomplete="off">
            </div> --}}
        </div>
    </div>
</div>
  



        <table id="listAjaxDataTable" class="table text-nowrap w-100  mb-3">
            <thead>
                <tr>
                    <th data-ftcol="sno" > S.No </th>
                    <th data-ftcol="CustomerName">Customer Name</th>
                    <th data-ftcol="CustomerPhone">CustomePhone</th>
                    <th data-ftcol="From Place">From Place</th>
                    <th data-ftcol="To Place">To Place</th>
                     {{-- <th data-ftcol="start_image">Start Image</th> --}}
                    <th data-ftcol="Car Type">Car Type</th>
                    <th data-ftcol="Pickup Date">Pickup Date</th>
                    <th data-ftcol="Pickup Time"> Pickup Time </th>
                    <th data-ftcol="Message">Message </th>
                    <th data-ftcol="Action"> Action </th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>




   
   

@endsection

@section('script1')


<script src="{{ asset('public/admin_assets/js/jquery.min.js') }}"></script>




<script>
    $(document).ready(function() {

            var reorderStart = -1; 
        $('th').on("click", function(event) {
            if ($(event.target).is("input") || $(event.target).is("select")) {
                event.stopImmediatePropagation();
            }
        });
        var sno = 1;
     var dataTablecol = [
    {
        name: "serial_no",
        searchable: false,
        sortable: false,
        render: function (data, type, row, meta) {
            return meta.row + meta.settings._iDisplayStart + 1;
        }
    },
    {
        data: 'name',
        name: 'name',
        searchable: true,
        sortable: false
    },
    {
        data: 'mobile',
        name: 'mobile',
        searchable: true,
        sortable: false
    },
    {
        data: 'from_place',
        name: 'from_place',
        searchable: true,
        sortable: false
    },
    {
        data: 'to_place',
        name: 'to_place',
        searchable: true,
        sortable: false
    },
    {
        data: 'car_type',
        name: 'car_type',
        searchable: true,
        sortable: false
    },
    {
        data: 'pickup_date',
        name: 'pickup_date',
        searchable: true,
        sortable: false
    },
    {
        data: 'pickup_time',
        name: 'pickup_time',
        searchable: true,
        sortable: false
    },
    {
        data: 'message',
        name: 'message',
        searchable: true,
        sortable: false,
        render: function (data) {
            return `<div class="text-truncate-ellipsis" title="${data}">${data}</div>`;
        }
    },
    {
        searchable: false,
        sortable: false,
        data: 'id',
        render: function(data, type, row, meta) {
            var url = "{{ route('admin.ContactusManagement') }}";
            var viewLink = '<a class="" href="' + url + '/' + data + '/view" title="View">' +
                '<i class="mdi mdi-eye" style="color: #009378; font-size: 20px"></i>' +
                '</a>';
            var deleteLink = '<a data-id="' + data + '" class="deleteRow" href="#" title="Delete">' +
                '<i class="mdi mdi-delete" style="color: red; font-size: 20px;"></i>' +
                '</a>';
            return viewLink + '&nbsp;' + deleteLink;
        }
    },
];

            
        
        var listAjaxDataTable = $('#listAjaxDataTable').DataTable({
            // "order": [
            //     [0, "desc"]
            // ],
            "processing": true,
            "serverSide": true,
            "colReorder": true,
            "columns": dataTablecol,
            "ordering": false,
            "bAutoWidth": false,
            // "dom": 'ltpr',
            "dom": " <'row'<'col-sm-12 mt-3'tr>><'row'<'col-sm-2'l><'col-sm-6'i><'col-sm-4'p>>",
            "drawCallback": function(settings) {
                var response = settings.json;
                if (response.recordsTotal > 0) {
                    $('#exportreport').show();
                } else {
                    $('#exportreport').hide();
                }
            },
            "ajax": DataTable.pipeline({
                url: "{{ route('admin.ContactusManagement-dataindex') }}",
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                pages: 5 // number of pages to cache
            }),
        });

       
        $('#customsearch').on('keyup change', function () {
    let value = $(this).val();
    listAjaxDataTable.columns().every(function () {
        this.search('1'); // reset
    });

    listAjaxDataTable
        .column('2').search(value)
        
        
});


            

        $('table').on('click', '.deleteRow', function(e) {
            e.preventDefault();
            $chId = $(this).data('id');
            var k = confirm("Are you sure to Delete this record.");
            if (k == true) {
                $.ajax({
                    url: "{{ route('admin.ContactusManagement') }}/" + $chId,
                    method: "DELETE",
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    error: function(data) {
                        toastr.error("Error Occured. Please Try Again Later.");
                    },
                    success: function(result) {
                        result = JSON.stringify(result)
                        result = JSON.parse(result);
                        if (result.status == 200) {
                            toastr.success("Deleted Successfully");
                            listAjaxDataTable.clearPipeline().draw();
                        } else {
                            toastr.error("Error Occured. Please Try Again Later.");
                        }
                    }
                });
            }
        });

    });
 

 
</script>

@endsection
 