@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="mb-4">
    <h4>Booking Details</h4>
    <div class="card">
        <div class="card-body">
            <table class="table table-bordered">
                <tbody>
                    <tr>
                        <th style="width: 30%;">Customer Name</th>
                        <td>{{ $getRow->customer_name ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Phone</th>
                        <td>{{ $getRow->phone ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>From Address</th>
                        <td style="white-space: normal;">{{ $getRow->from_address ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>To Address</th>
                        <td style="white-space: normal;">{{ $getRow->to_address ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Notify Driver</th>
                        <td class="text-capitalize">{{ $getRow->notify_driver ?? 'N/A' }}</td>
                    </tr>
                    {{-- <tr>
                        <th>Trip Status</th>
                        <td>
                            <span class="badge {{ $getRow->trip_status ? 'bg-success' : 'bg-warning' }}">
                                {{ $getRow->trip_status ? 'Accepted' : 'Pending' }}
                            </span>
                        </td>
                    </tr> --}}
                    <tr>
                        <th>Assigned Driver</th>
                        <td>
                            @if($get_driver)
                                {{ $get_driver->driver_name }} ({{ $get_driver->user_name }})
                            @else
                                <em>No driver assigned</em>
                            @endif
                        </td>
                    </tr>
                    {{-- <tr>
                        <th>Pickup Coordinates</th>
                        <td>{{ $getRow->start_latitute }}, {{ $getRow->start_longitute }}</td>
                    </tr>
                    <tr>
                        <th>Dropoff Coordinates</th>
                        <td>{{ $getRow->end_latitute }}, {{ $getRow->end_longitute }}</td>
                    </tr> --}}
                </tbody>
            </table>

            <div class="mt-4">
                <a href="{{ route('admin.BookingManagement-index') }}" class="btn btn-dark">
                    Back to List
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
