
@extends('admin.adminmaster')

@section('style1')
<link href="{{asset('public/admin_assets/plugins/datatables.net-bs5/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet">
<link href="{{asset('public/admin_assets/plugins/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css')}}" rel="stylesheet">
<link href="{{asset('public/admin_assets/plugins/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css')}}" rel="stylesheet">
<style>
.containerbutton {
    display: flex;
    justify-content: flex-end; /* Aligns button to the right */
    margin-bottom: 10px; /* Optional: Space between button and table */
}
</style>

@endsection






@section('contentarea')

<div id="datatable" class="mb-5">
    
    <h4>USER - ROLES</h4>
    <div class="containerbutton">
      
       
    <a href="{{route('admin.UserRoles-add') }}" class="btn btn-outline-theme">ADD</a>
    </div>
    <div class="card">
    <div class="card-body">
    <table id="datatableDefault" class="table text-nowrap w-100">
        <thead>
            <tr>
                <th> S.No</th>
                <th>Name</th>
                {{-- <th>Status</th> --}}
                <th width="40%">Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($sel_roleList as $key=>$roleList)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $roleList }}</td>
               
                <td>
                
                    <a href="{{ route('admin.UserRoles-edit',$key) }}" class="btn btn-success">Edit</a>
                  

                 
                    <form action="{{ route('admin.UserRoles-delete', $key) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger mx-2 deleteRow" data-id="{{ $key }}">Delete</button>
                    </form>
            
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    </div>
    <div class="card-arrow">
    <div class="card-arrow-top-left"></div>
    <div class="card-arrow-top-right"></div>
    <div class="card-arrow-bottom-left"></div>
    <div class="card-arrow-bottom-right"></div>
    </div>
    <div class="hljs-container">
    <pre><code class="xml" data-url="assets/data/table-plugins/code-1.json"></code></pre>
    </div>
    </div>
    </div>
    </div>
    @endsection

    @section('script1')


    <script src="{{ asset('public/admin_assets/js/jquery.min.js') }}"></script>

    <script src="{{ asset('public/admin_assets/plugins/datatables.net/js/dataTables.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-bs5/js/dataTables.bootstrap5.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons/js/dataTables.buttons.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons/js/buttons.colVis.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons/js/buttons.flash.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons/js/buttons.html5.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons/js/buttons.print.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-responsive/js/dataTables.responsive.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/plugins/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
    <script src="{{ asset('public/admin_assets/js/demo/table-plugins.demo.js')}}" type="e6e3709f8eb291e343b94369-text/javascript"></script>
<script>

    $(document).ready(function() {
        $('table').on('click', '.deleteRow', function(e) {
            e.preventDefault();
            var $chId = $(this).data('id');
    
            if (confirm("Are you sure to delete this record?")) {
                $.ajax({
                    url: "{{ route('admin.UserRoles-delete', '') }}/" + $chId,
                    type: "POST",
                    data: {
                        _method: 'DELETE',
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(results) {
                        if (results.status == 200) {
                            toastr.success("Deleted Successfully");
                            // Redraw the table to reflect the changes
                            $('#datatableDefault').DataTable().ajax.reload(null, false); // User paging is not reset on reload
                        } else {
                            toastr.error("Error Occurred. Please Try Again Later.");
                        }
                    },
                    error: function(data) {
                        toastr.error("Error Occurred. Please Try Again Later.");
                    }
                });
            }
        });
    });
</script>
    
    @endsection