<?php

use App\Http\Controllers\Admin\BookingManagementController;
use App\Http\Controllers\Admin\ContactusController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\DriverManagementController;
use App\Http\Controllers\Admin\DriverTripsManagementController;
use App\Http\Controllers\Admin\PaymentManagementController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\ReportManagementController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\TestController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\UserManagementController;
use App\Http\Controllers\Admin\UserRoleController;
use App\Http\Controllers\Admin\VehicleManagementController;
use App\Http\Controllers\AutomateController;
use App\Http\Controllers\Front\FrontendController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use \Illuminate\Support\Facades\Artisan;

Route::get('/automate/createmenutopermission', [AutomateController::class, 'createmenutopermission'])->name('automate.createmenutopermission');

Route::get('clear-all', function () {
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('config:clear');
    Artisan::call('view:clear');
    Artisan::call('optimize:clear');
    dd("all cleared");
});

Route::get('cache-clear', function () {
    Artisan::call('cache:clear');
    dd("cache cleared");
});

Route::get('config-cache', function () {
    Artisan::call('config:cache');
    dd("Done");
});

Route::get('storage-link', function () {
    Artisan::call('storage:link');
    dd("Done");
});

// Route::get('/', function () {
//     return view('auth.login');
// });
// Route::get('/', [FrontendController::class, 'home'])->name('index');
Route::get('/', function () {
    return view('front.index');
})->name('home');
Route::post('/contactsave', [FrontendController::class, 'contactsave'])->name('contact.save');

Route::get('/test', [TestController::class, 'test'])->name('test');
Route::get('/test3', [TestController::class, 'test3'])->name('test3');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::name('admin.')->middleware('auth')->prefix('admin')->group(function () {

    Route::get('/clear-data', function () {
        DB::table('entry_managements')->truncate();
        DB::table('entry_unique_details')->truncate();
        DB::table('entry_details')->truncate();

        DB::table('auctions_managements')->truncate();
        DB::table('auctions_details')->truncate();

        DB::table('weight_managements')->truncate();
        DB::table('weight_details')->truncate();

        DB::table('invoice_masters')->truncate();
        DB::table('invoice_details')->truncate();
        DB::table('invoice_masters_deleted')->truncate();
        DB::table('invoice_details_deleted')->truncate();

        DB::table('tray_balance')->truncate();
        DB::table('cash_management')->truncate();
        DB::table('cash_details')->truncate();
        DB::table('log_reports')->truncate();

        dd("all data cleared");
    })->name('clear-data');

    Route::get('/dashboard', [DashboardController::class, 'index'])
        ->middleware(['auth', 'verified'])
        ->name('dashboard');

    Route::group([' middleware' => ['role:super-admin|admin']], function () {

        Route::get('/driver-trip-details', [BookingManagementController::class, 'testController']);

        Route::resource('permissions', PermissionController::class);
        // Route::get('permissions/{permissionId}/delete', [PermissionController::class, 'destroy']);
        Route::delete('admin/permissions/{permissionId}', [PermissionController::class, 'destroy'])->name('admin.permissions.destroy');

        Route::resource('roles', RoleController::class);
        Route::get('roles/{roleId}/delete', [RoleController::class, 'destroy']);
        Route::get('roles/{roleId}/give-permissions', [RoleController::class, 'addPermissionToRole']);
        Route::put('roles/{roleId}/give-permissions', [RoleController::class, 'givePermissionToRole'])->name('givePermissionToRole');

        Route::resource('users', UserController::class);
        Route::get('users/{userId}/delete', [UserController::class, 'destroy']);

        // ---------------Test ROUTES----------------

        Route::get('/test', [TestController::class, 'test'])->name('test');
        Route::get('/test1', [TestController::class, 'test1'])->name('test1');

        Route::get('/test3', [TestController::class, 'test3'])->name('test3');

        Route::get('/test4', [TestController::class, 'test4'])->name('test4');

        Route::get('/test5', [TestController::class, 'test5'])->name('test5');

        // ---------------ROLES----------------s

        Route::get('/UserRoles', [UserRoleController::class, 'list'])->name('UserRoles');
        Route::get('/UserRoles-list', [UserRoleController::class, 'list'])->name('UserRoles-list');
        Route::post('/UserRoles-datalist', [UserRoleController::class, 'datalist'])->name('UserRoles-datalist');
        Route::get('/UserRoles-add', [UserRoleController::class, 'add'])->name('UserRoles-add');
        Route::post('/UserRoles-add', [UserRoleController::class, 'save'])->name('UserRoles-save');
        Route::get('/UserRoles/{UserRolesId}/edit', [UserRoleController::class, 'edit'])->name('UserRoles-edit')->where('UserRolesId', '[0-9]+');
        Route::PUT('/UserRoles/{UserRolesId}', [UserRoleController::class, 'update'])->name('UserRoles-update')->where('UserRolesId', '[0-9]+');
        Route::get('/UserRoles/{UserRolesId}/view', [UserRoleController::class, 'view'])->name('UserRoles-view')->where('UserRolesId', '[0-9]+');
        Route::DELETE('/UserRoles/{UserRolesId}', [UserRoleController::class, 'destroy'])->name('UserRoles-delete')->where('UserRolesId', '[0-9]+');

        Route::get('/UserRoles-listindex', [UserRoleController::class, 'listindex'])->name('UserRoles-listindex');
        Route::post('/UserRoles-dataindex', [UserRoleController::class, 'dataindex'])->name('UserRoles-dataindex');

        // ---------------User Management Route----------------

        Route::get('/UserManagement', [UserManagementController::class, 'index'])->name('UserManagement');

        Route::get('/UserManagement-index', [UserManagementController::class, 'index'])->name('UserManagement-index');
        Route::post('/UserManagement-dataindex', [UserManagementController::class, 'dataindex'])->name('UserManagement-dataindex');
        Route::get('/UserManagement-create', [UserManagementController::class, 'create'])->name('UserManagement-create');
        Route::post('/UserManagement-store', [UserManagementController::class, 'store'])->name('UserManagement-store');
        Route::get('/UserManagement/{UserManagementId}/edit', [UserManagementController::class, 'edit'])->name('UserManagement-edit')->where('UserManagementId', '[0-9]+');
        Route::PUT('/UserManagement/{UserManagementId}', [UserManagementController::class, 'update'])->name('UserManagement-update')->where('UserManagementId', '[0-9]+');
        Route::get('/UserManagement/{UserManagementId}/view', [UserManagementController::class, 'show'])->name('UserManagement-show')->where('UserManagementId', '[0-9]+');
        Route::DELETE('/UserManagement/{UserManagementId}', [UserManagementController::class, 'destroy'])->name('UserManagement-destroy')->where('UserManagementId', '[0-9]+');

        Route::post('/check-phone', [UserManagementController::class, 'check_Phone'])->name('check-phone');
        Route::post('/edit-check-phone', [UserManagementController::class, 'edit_check_Phone'])->name('edit-check-phone');

        // ---------------Driver Management Route----------------

        Route::get('/DriverManagement', [DriverManagementController::class, 'index'])->name('DriverManagement');

        Route::get('/DriverManagement-index', [DriverManagementController::class, 'index'])->name('DriverManagement-index');
        Route::post('/DriverManagement-dataindex', [DriverManagementController::class, 'dataindex'])->name('DriverManagement-dataindex');
        Route::get('/DriverManagement-create', [DriverManagementController::class, 'create'])->name('DriverManagement-create');
        Route::post('/DriverManagement-store', [DriverManagementController::class, 'store'])->name('DriverManagement-store');
        Route::get('/DriverManagement/{DriverManagementId}/edit', [DriverManagementController::class, 'edit'])->name('DriverManagement-edit')->where('DriverManagementId', '[0-9]+');
        Route::PUT('/DriverManagement/{DriverManagementId}', [DriverManagementController::class, 'update'])->name('DriverManagement-update')->where('DriverManagementId', '[0-9]+');
        Route::get('/DriverManagement/{DriverManagementId}/view', [DriverManagementController::class, 'show'])->name('DriverManagement-show')->where('DriverManagementId', '[0-9]+');
        Route::DELETE('/DriverManagement/{DriverManagementId}', [DriverManagementController::class, 'destroy'])->name('DriverManagement-destroy')->where('DriverManagementId', '[0-9]+');
        Route::delete('/driver-documents/{document}', [DriverManagementController::class, 'destroyDocument'])
            ->name('driverdocuments-destroy');
        Route::post('/update-status/driver', [DriverManagementController::class, 'updateStatus'])->name('driverupdate-status');
        Route::post('/check-username', [DriverManagementController::class, 'check_username'])->name('check-username');
        Route::post('/edit-check-username', [UserManagementController::class, 'edit_check_username'])->name('edit_check_username');
        Route::post('/check-vehiclenumber', [DriverManagementController::class, 'check_vehiclenumber'])->name('check-vehiclenumber');
        Route::post('/edit-check-vehiclenumber', [UserManagementController::class, 'edit_check_vehiclenumber'])->name('edit_check_vehiclenumber');
        // ---------------Vehicle Management Route----------------

        Route::get('/VehicleManagement', [VehicleManagementController::class, 'index'])->name('VehicleManagement');

        Route::get('/VehicleManagement-index', [VehicleManagementController::class, 'index'])->name('VehicleManagement-index');
        Route::post('/VehicleManagement-dataindex', [VehicleManagementController::class, 'dataindex'])->name('VehicleManagement-dataindex');
        Route::get('/VehicleManagement-create', [VehicleManagementController::class, 'create'])->name('VehicleManagement-create');
        Route::post('/VehicleManagement-store', [VehicleManagementController::class, 'store'])->name('VehicleManagement-store');
        Route::get('/VehicleManagement/{VehicleManagementId}/edit', [VehicleManagementController::class, 'edit'])->name('VehicleManagement-edit')->where('VehicleManagementId', '[0-9]+');
        Route::PUT('/VehicleManagement/{VehicleManagementId}', [VehicleManagementController::class, 'update'])->name('VehicleManagement-update')->where('VehicleManagementId', '[0-9]+');
        Route::get('/VehicleManagement/{VehicleManagementId}/view', [VehicleManagementController::class, 'show'])->name('VehicleManagement-show')->where('VehicleManagementId', '[0-9]+');
        Route::DELETE('/VehicleManagement/{VehicleManagementId}', [VehicleManagementController::class, 'destroy'])->name('VehicleManagement-destroy')->where('VehicleManagementId', '[0-9]+');
        Route::post('/update-status/vehicle', [VehicleManagementController::class, 'updateStatus'])->name('vehicleupdate-status');

        // ---------------Booking  Management Route----------------

        Route::get('/BookingManagement', [BookingManagementController::class, 'index'])->name('BookingManagement');
        Route::get('/BookingManagement-index', [BookingManagementController::class, 'index'])->name('BookingManagement-index');
        Route::post('/BookingManagement-dataindex', [BookingManagementController::class, 'dataindex'])->name('BookingManagement-dataindex');
        Route::get('/BookingManagement-create', [BookingManagementController::class, 'create'])->name('BookingManagement-create');
        Route::post('/BookingManagement-store', [BookingManagementController::class, 'store'])->name('BookingManagement-store');
        Route::get('/BookingManagement/{BookingManagementId}/edit', [BookingManagementController::class, 'edit'])->name('BookingManagement-edit')->where('BookingManagementId', '[0-9]+');
        Route::PUT('/BookingManagement/{BookingManagementId}', [BookingManagementController::class, 'update'])->name('BookingManagement-update')->where('BookingManagementId', '[0-9]+');
        Route::get('/BookingManagement/{BookingManagementId}/edit1', [BookingManagementController::class, 'edit1'])->name('BookingManagement-edit1')->where('BookingManagementId', '[0-9]+');
        Route::PUT('/BookingManagement/{BookingManagementId}', [BookingManagementController::class, 'update1'])->name('BookingManagement-update1')->where('BookingManagementId', '[0-9]+');
        Route::get('/BookingManagement/{BookingManagementId}/view', [BookingManagementController::class, 'show'])->name('BookingManagement-show')->where('BookingManagementId', '[0-9]+');
        Route::DELETE('/BookingManagement/{BookingManagementId}', [BookingManagementController::class, 'destroy'])->name('BookingManagement-destroy')->where('BookingManagementId', '[0-9]+');
        Route::post('/update-status/Booking', [BookingManagementController::class, 'updateStatus'])->name('Bookingupdate-status');
		
        Route::get('/BookingManagement-test', [BookingManagementController::class, 'test'])->name('test');

        Route::post('/Booking-management/get-row', [BookingManagementController::class, 'getSingleRow'])->name('BookingManagement.getRow');
		Route::post('/BookingManagement/get-estimation', [BookingManagementController::class, 'estimateFare'])->name('BookingManagement.getEstimation');


        Route::post('/drivers-nearby', [BookingManagementController::class, 'getNearbyDrivers'])->name('getNearbyDrivers');
        Route::post('/drivers-all', [BookingManagementController::class, 'getAllOnlineDrivers'])->name('getAllOnlineDrivers');

        Route::post('/send-otp', [BookingManagementController::class, 'sendOtp'])->name('Bookingsendotp');
        // Route::post('/bookingcancel', [BookingManagementController::class, 'cancelRide'])->name('Bookingcancel');
        Route::match(['get', 'post'], '/bookingcancel', [BookingManagementController::class, 'cancelRide'])->name('Bookingcancel');

        // routes/web.php
        // routes/web.php
        Route::get('/online-drivers', [BookingManagementController::class, 'getOnlineDrivers'])->name('onlineDrivers');

        // Route::post('get-all-online-drivers', [BookingManagementController::class, 'getAllOnlineDrivers'])->name('getAllOnlineDrivers');

        // ---------------Report  Management Route----------------
        Route::get('/ReportManagement', [ReportManagementController::class, 'index'])->name('ReportManagement');
        Route::post('/ReportManagement-dataindex', [ReportManagementController::class, 'dataindex'])->name('ReportManagement-dataindex');
        Route::get('/ReportManagement-index', [ReportManagementController::class, 'index'])->name('ReportManagement-index');

        Route::get('/DriverReport', [ReportManagementController::class, 'Driverindex'])->name('DriverReport');
        Route::get('/DriverReport-index', [ReportManagementController::class, 'DriverReport'])->name('DriverReport-index');
        Route::post('/Driver-report/recalculate/{driver_id}', [ReportManagementController::class, 'recalculatePayment'])->name('DriverReport-recalculate');

        Route::get('/CustomerReport', [ReportManagementController::class, 'Customerindex'])->name('CustomerReport');
        Route::get('/CustomerReport-index', [ReportManagementController::class, 'CustomerReport'])->name('CustomerReport-index');

        //--------------------Driver Trips----------------

        Route::get('/DriverTripsManagement', [DriverTripsManagementController::class, 'index'])->name('DriverTripsManagement');
        Route::post('/DriverTripsManagement-dataindex', [DriverTripsManagementController::class, 'dataindex'])->name('DriverTripsManagement-dataindex');
        Route::match(['get', 'post'], '/DriverTripsManagement-index', [DriverTripsManagementController::class, 'index'])->name('DriverTripsManagement-index');

        Route::get('/DriverTripsManagement/{DriverTripsManagementId}/edit1', [DriverTripsManagementController::class, 'edit1'])->name('DriverTripsManagement-edit1')->where('DriverTripsManagementId', '[0-9]+');
        Route::PUT('/DriverTripsManagement/{DriverTripsManagementId}', [DriverTripsManagementController::class, 'update1'])->name('DriverTripsManagement-update1')->where('DriverTripsManagementId', '[0-9]+');

        //---------------Payment Management--------------

        Route::get('/PaymentManagement', [PaymentManagementController::class, 'index'])->name('PaymentManagement');
        // Route::post('/PaymentManagement-dataindex', [PaymentManagementController::class, 'dataindex'])->name('PaymentManagement-dataindex');
        Route::match(['get', 'post'], '/PaymentManagement-index', [PaymentManagementController::class, 'index'])->name('PaymentManagement-index');
        Route::get('/payment-management/create', [PaymentManagementController::class, 'create'])->name('PaymentManagement-create');
        Route::post('/payment-management/store', [PaymentManagementController::class, 'store'])->name('PaymentManagement-store');
        Route::get('/payment-management/gettripdata', [PaymentManagementController::class, 'getTripData'])->name('PaymentManagement-getTripData');

        Route::get('/ApprovalWaiting', [PaymentManagementController::class, 'approvalwaiting'])->name('ApprovalWaiting');
        Route::get('/ApprovalWaiting-index', [PaymentManagementController::class, 'approvalwaiting'])->name('ApprovalWaiting-index');
        Route::post('/update-status/payment', [PaymentManagementController::class, 'updatePayStatus'])->name('Payupdate-status');

        //-------------------Contactus Management------------------------------
        Route::get('/ContactusManagement', [ContactusController::class, 'index'])->name('ContactusManagement');
        Route::get('/ContactusManagement-index', [ContactusController::class, 'index'])->name('ContactusManagement-index');
        Route::post('/ContactusManagement-dataindex', [ContactusController::class, 'dataindex'])->name('ContactusManagement-dataindex');
        Route::get('/ContactusManagement/{ContactusManagementId}/view', [ContactusController::class, 'show'])->name('ContactusManagement-show')->where('ContactusManagementId', '[0-9]+');
        Route::DELETE('/ContactusManagement/{ContactusManagementId}', [ContactusController::class, 'destroy'])->name('ContactusManagement-destroy')->where('ContactusManagementId', '[0-9]+');


		Route::get('/booking/estimate-fare', [BookingManagementController::class, 'estimateFare'])->name('booking.estimateFare');

    });
});

require __DIR__ . '/auth.php';
