 

<?php $__env->startSection('contentarea'); ?>
<div class="container mt-4">
    <h4>Add New Payment</h4>
    <form method="POST" action="<?php echo e(route('admin.PaymentManagement-store')); ?>" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <div class="mb-3">
            <label for="driver_id" class="form-label">Driver</label>
            <select name="driver_id" id="driver_id" class="form-select" required>
                <option value="">Select Driver</option>
                <?php $__currentLoopData = $drivers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($driver->id); ?>"><?php echo e($driver->driver_code); ?> - <?php echo e($driver->driver_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="trip_date" class="form-label">Trip Date</label>
            <input type="date" name="trip_date" class="form-control" >
        </div>

       <div class="mb-3">
    <label for="amount" class="form-label">Total Amount (₹)</label>
    <input type="number" name="amount"   class="form-control" readonly>
</div>

<div class="mb-3">
    <label for="commission_amount" class="form-label">Commission Amount (₹)</label>
    <input type="number" name="commission_amount" step="0.01" class="form-control" readonly>
</div>

<div class="mb-3">
    <label for="paid_amount" class="form-label">Driver Paid Amount (₹)</label>
    <input type="number" name="paid_amount" step="0.01" class="form-control">
</div>


        <div class="mb-3">
            <label for="payment_receipt" class="form-label">Attach Receipt</label>
            <input type="file" name="payment_receipt" class="form-control" >
        </div>


        <button type="submit" class="btn btn-success">Save Payment</button>
        <a href="<?php echo e(route('admin.PaymentManagement-index')); ?>" class="btn btn-secondary">Cancel</a>
    </form>
</div>
<?php $__env->stopSection(); ?>
 
<?php $__env->startSection('script2'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const driverSelect = document.getElementById('driver_id');
    const dateInput = document.querySelector('input[name="trip_date"]');

   function fetchTripData() {
    const driverId = driverSelect.value;
    const tripDate = dateInput.value;

    console.log("Fetching data for driver:", driverId, "on", tripDate);

    if (driverId && tripDate) {
      fetch(`<?php echo e(route('admin.PaymentManagement-getTripData')); ?>?driver_id=${driverId}&trip_date=${tripDate}`)

            .then(response => {
                console.log("Raw response:", response);
                return response.json();
            })
            .then(data => {
                console.log("Data received:", data);
                if (data.success) {
                    document.querySelector('input[name="amount"]').value = data.amount;
                    document.querySelector('input[name="commission_amount"]').value = data.commission_amount;
                    document.querySelector('input[name="driver_paid_amount"]').value = data.driver_paid_amount;
                    document.querySelector('input[name="balance_amount"]').value = data.balance_amount;
                } else {
                    alert(data.message);
                }
            })
            .catch(error => {
                console.error("Error fetching trip data:", error);
            });
    }
}


    driverSelect.addEventListener('change', fetchTripData);
    dateInput.addEventListener('change', fetchTripData);
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/vaigainammataxi.com/resources/views/admin/payment_management/add.blade.php ENDPATH**/ ?>