<?php $__env->startSection('contentarea'); ?>
<div class="mb-4">
    <h4>Booking Details</h4>
    <div class="card">
        <div class="card-body">
            <table class="table table-bordered">
                <tbody>
                    <tr>
                        <th style="width: 30%;">Customer Name</th>
                        <td><?php echo e($getRow->customer_name ?? 'N/A'); ?></td>
                    </tr>
                    <tr>
                        <th>Phone</th>
                        <td><?php echo e($getRow->phone ?? 'N/A'); ?></td>
                    </tr>
                    <tr>
                <th>Pickup Location</th>
                <td style="white-space: normal;"><?php echo e(($fare_summary && $fare_summary->pickup_location)? $fare_summary->pickup_location : 'N/A'); ?></td>
            </tr>
            <tr>
                <th>Drop Location</th>
                <td style="white-space: normal;"><?php echo e(($fare_summary && $fare_summary->drop_location) ? $fare_summary->drop_location : 'N/A'); ?></td>
            </tr>
                    <tr>
                        <th>Notify Driver</th>
                        <td class="text-capitalize"><?php echo e($getRow->notify_driver ?? 'N/A'); ?></td>
                    </tr>
                    
                    <tr>
                        <th>Assigned Driver</th>
                        <td>
                            <?php if($get_driver): ?>
                                <?php echo e($get_driver->driver_name); ?> (<?php echo e($get_driver->user_name); ?>)
                            <?php else: ?>
                                <em>No driver assigned</em>
                            <?php endif; ?>
                        </td>
                    </tr>
                  <tr>
             <th>Car Type</th>
            <td><?php echo e($getRow->cartype_name); ?></td>
            </tr>

			<tr>
    <th>Travel Type</th>
    <td>
        <?php if($getRow->traveltype_id == 1): ?>
            Indoor Package
        <?php elseif($getRow->traveltype_id == 2): ?>
            Outdoor Package
        <?php else: ?>
            N/A
        <?php endif; ?>
    </td>
</tr>

<tr>
    <th>Vehicle A/C Type</th>
    <td><?php echo e($getRow->ac_type); ?>

    </td>
</tr>



              <tr>
                <th>Start Date</th>
                <td><?php echo e($getRow->booking_date ?? 'N/A'); ?></td>
            </tr>
             <tr>
                <th>End Date</th>
                <td><?php echo e(($fare_summary && $fare_summary->end_date)? $fare_summary->end_date : 'N/A'); ?></td>
            </tr>
              <tr>
                <th>Start Time</th>
                <td><?php echo e(($fare_summary && $fare_summary->start_time)? $fare_summary->start_time : 'N/A'); ?></td>
            </tr>
            <tr>
                <th>End Time</th>
                <td><?php echo e(($fare_summary && $fare_summary->end_time)?  $fare_summary->end_time : 'N/A'); ?></td>
            </tr>
             <tr>
                <th>Travel Minutes</th>
                <td><?php echo e(($fare_summary && $fare_summary->travel_minutes)? $fare_summary->travel_minutes : 'N/A'); ?></td>
            </tr>
            <tr>
                <th>Total KM Travelled</th>
                <td><?php echo e(($fare_summary && $fare_summary->total_km_travelled)? $fare_summary->total_km_travelled : 'N/A'); ?></td>
            </tr>
            <tr>
                <th>Package KM</th>
                <td><?php echo e(($fare_summary && $fare_summary->package_km)? $fare_summary->package_km : 'N/A'); ?></td>
            </tr>
            
            
            
            <tr>
                <th>Base Fare</th>
                <td><?php echo e(($fare_summary && $fare_summary->base_fare)? $fare_summary->base_fare : 'N/A'); ?></td>
            </tr>            
            <tr>
                <th>Extra KM Fare</th>
                <td><?php echo e(($fare_summary && $fare_summary->extra_km_fare)? $fare_summary->extra_km_fare : '0'); ?> <?php if($fare_summary): ?><i>(<?php echo e($fare_summary->extra_km ?? '0'); ?> Km * Rs.<?php echo e($fare_summary->per_km_charge ?? '0'); ?> )</i><?php endif; ?></td>
            </tr>
            
             <tr>
                <th>Extra Hour Fare</th>
                <td><?php echo e(($fare_summary && $fare_summary->extraHourFare)? $fare_summary->extraHourFare : 'N/A'); ?> <?php if($fare_summary && $packRow && $packRow->local_type==1): ?><i>(<?php echo e(trim($extrhourinmin)?  trim($extrhourinmin) : '0 Hrs'); ?> * Rs.<?php echo e($fare_summary->hr_fare ?? '0'); ?> )</i><?php endif; ?></td>
            </tr>
            <tr>
                <th>Waiting Charge</th>
                <td><?php echo e(($fare_summary && $fare_summary->waiting_charge)? $fare_summary->waiting_charge :  'N/A'); ?><?php if($fare_summary && $packRow && $packRow->local_type==2): ?><i>(<?php echo e(trim($extrhourinmin)?  trim($extrhourinmin) : '0 Hrs'); ?>)<?php endif; ?></td>
            </tr>
            <tr>
                <th>Extra Charge</th>
                <td><?php echo e($getRow->extra_fair ?? 'N/A'); ?></td>
            </tr>
 			<tr>
                <th>Waiting Charge (Custom)</th>
                <td><?php echo e($getRow->waiting_charge_edit ?? 'N/A'); ?></td>
            </tr>
            
            <tr>
                <th>Discount Amount</th>
                <td><?php echo e($getRow->extra_discountamount ?? 'N/A'); ?></td>
            </tr>
            <tr>
                <th>Hills Fare <?php if($fare_summary && $fare_summary->hills_km && $fare_summary->hills_km > 0): ?>(<?php echo e($fare_summary->hills_km); ?>)  <?php else: ?> 0 <?php endif; ?> Km</th>
                <td><?php echo e(($fare_summary && $fare_summary->hills_fare)? $fare_summary->hills_fare : 'N/A'); ?></td>
            </tr>
            <tr>
                <th>Total Price</th>
                <td><strong>₹ <?php echo e(($fare_summary && $fare_summary->total_price) ? $fare_summary->total_price : 'N/A'); ?></strong></td>
            </tr>
           
          
          
                    
                </tbody>
            </table>

            <div class="mt-4">
                <a href="<?php echo e(route('admin.BookingManagement-index')); ?>" class="btn btn-dark">
                    Back to List
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/vaigainammataxi.com/resources/views/admin/booking_management/view.blade.php ENDPATH**/ ?>