<?php $__env->startSection('contentarea'); ?>
<div class="container mt-4">

    <h2 class="mb-4">Approval Reports</h2>

 
       

    
    <div class="table-responsive">
    <table class="table table-bordered">
    <thead>
        <tr>
            <th>Driver Details</th>
            <th>Payment Receipt</th> 
            
            <th>Paid Amount (₹)</th>
            <th>Balance Amount (₹)</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($data->driver_code . ' - ' . $data->driver_name); ?></td>

                
                <td>
                    <?php if(!empty($data->payment_receipt_image)): ?>
                        <img src="<?php echo e(asset('payment_receipts/' . $data->payment_receipt_image)); ?>" 
                             alt="Receipt" width="80" height="80" class="img-thumbnail">
                    <?php else: ?>
                        <span class="text-muted">No receipt</span>
                    <?php endif; ?>
                </td>

                
                
                <td>₹ <?php if($data->pay_status == 2): ?>
                    <?php echo e(number_format($data->paid_amount, 2)); ?><?php else: ?>
                    <?php echo e(number_format($data->req_amount, 2)); ?>

                <?php endif; ?></td>
                <td>₹ <?php echo e(number_format($data->pending_amount, 2)); ?></td>
                 <td>
                                <div id="status-<?php echo e($data->id); ?>">
                                
                        <?php if($data->pay_status == 0): ?>
                        <button onclick="setStatus(<?php echo e($data->id); ?>, 'approved')" class="btn btn-sm btn-success">Approve</button>
                        <button onclick="setStatus(<?php echo e($data->id); ?>, 'rejected')" class="btn btn-sm btn-danger">Reject</button>
                    <?php elseif($data->pay_status == 2): ?>
                        <span class="badge bg-success">Approved</span>
                    <?php elseif($data->pay_status == 1): ?>
                        <span class="badge bg-danger">Rejected</span>
                    
                    <?php endif; ?>
                </div>
            </td>

                </td>

                 
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="6" class="text-center text-muted">No data available for the selected filters.</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>

    </div>
<?php $__env->stopSection(); ?>
<script>
     function setStatus(id, status) {
        const statusDiv = document.getElementById('status-' + id);

        fetch("<?php echo e(route('admin.Payupdate-status')); ?>", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                id: id,
                status: status === 'approved' ? 2 : 1
            })
        })
        .then(res => {
            if (!res.ok) throw new Error("HTTP error " + res.status);
            return res.json();
        })
        .then(response => {
            if (response.success) {
                const badgeClass = status === 'approved' ? 'bg-success' : 'bg-danger';
                const label = status === 'approved' ? 'Approved' : 'Rejected';
                statusDiv.innerHTML = `<span class="badge ${badgeClass}">${label}</span>`;
            } else {
                alert(response.message || "Update failed");
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert("An error occurred");
        });
    }
</script>


<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/vaigainammataxi.com/resources/views/admin/payment_management/approval_waiting.blade.php ENDPATH**/ ?>