<?php $__env->startSection('contentarea'); ?>
<div class="container mt-4">

    <h2 class="mb-4">Driver Report</h2>

    <form method="GET" action="<?php echo e(route('admin.DriverReport-index')); ?>" class="row g-3 mb-4">
        <div class="col-md-3">
            <label for="from_date" class="form-label">From Date</label>
            <input type="date" id="from_date" name="from_date" value="<?php echo e(request('from_date')); ?>" class="form-control">
        </div>
        <div class="col-md-3">
            <label for="to_date" class="form-label">To Date</label>
            <input type="date" id="to_date" name="to_date" value="<?php echo e(request('to_date')); ?>" class="form-control">
        </div>
        <div class="col-md-3 align-self-end">
            <button type="submit" class="btn btn-primary">Search</button>
            <a href="<?php echo e(route('admin.DriverReport-index')); ?>" class="btn btn-secondary ms-2">Clear</a>
        <a href="<?php echo e(route('admin.DriverReport-index', array_merge(request()->all(), ['download' => 'pdf']))); ?>" class="btn btn-danger ms-2">Download PDF</a>        </div>
    </form>

 <div class="table-responsive">
    <table class="table table-bordered table-striped align-middle">
        <thead class="table-dark">
            <tr>
                <th>Driver ID</th>
                <th>Driver Name</th>
                <th>Opening KM</th>
                <th>Closing KM</th>
                <th>Total Amount (₹)</th>
                <th>Trip Dates</th>
           <!-- <th>Action</th> -->
            </tr>
        </thead>
        <tbody>
          <?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <tr>
        <td><?php echo e($booking->driver_id); ?></td>
        <td><?php echo e($booking->driver_name); ?></td>
        <td><?php echo e($booking->start_km); ?></td>
        <td><?php echo e($booking->end_km); ?></td>
        <td>₹<?php echo e(number_format($booking->total_price, 2)); ?></td>
        <td><?php echo e($booking->trip_date ? \Carbon\Carbon::parse($booking->trip_date)->format('d-m-Y') : '-'); ?></td>
         <!-- <td>
            <form action="<?php echo e(route('admin.DriverReport-recalculate', ['driver_id' => $booking->driver_id])); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="trip_date" value="<?php echo e($booking->trip_date); ?>">
                <button type="submit" class="btn btn-warning btn-sm">Recalculate</button>
            </form>
        </td> -->
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <tr>
        <td colspan="7" class="text-center text-muted">No data available for the selected filters.</td>
    </tr>
<?php endif; ?>
        </tbody>
    </table>
</div>


</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/vaigainammataxi.com/resources/views/admin/report_management/driver_report.blade.php ENDPATH**/ ?>