<?php $__env->startSection('style1'); ?>
<style>
.searcharea > div {
    padding-right:10px;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('contentarea'); ?>
<div class="container mt-4">

    <h2 class="mb-4">Payment Management</h2>

    <form method="post" action="<?php echo e(route('admin.PaymentManagement-index')); ?>" id="myForm" class="row g-3 mb-4">
        <?php echo method_field('post'); ?>
        <?php echo csrf_field(); ?>
        <input type="hidden" name="action_type" id="action_type" value="0">

        <div class="col-md-12 searcharea" style="display: flex">
            <div>
                <label for="from_date" class="form-label">From Date</label>
                <input type="text" id="from_date" name="from_date" value="<?php echo e($sfrom_date ?? ""); ?>" class="form-control"
                    readonly>
            </div>
            <div>
                <label for="to_date" class="form-label">To Date</label>
                <input type="text" id="to_date" name="to_date" value="<?php echo e($sto_date ?? ""); ?>" class="form-control"
                    readonly>
            </div>

            <div><label for="driver_name" class="form-label">Driver Name / Id</label>
                <select id="driver_name" name="driver_name">
                    <option value="0" <?php if($sdriver_name=="0" ): ?> selected <?php endif; ?>>All</option>
                    <?php $__currentLoopData = $driverList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $driverRow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($driverRow->id); ?>" <?php if($sdriver_name==$driverRow->id): ?> selected <?php endif; ?>><?php echo e($driverRow->driver_code); ?> - <?php echo e($driverRow->driver_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div><label for="status1" class="form-label">Payment Status</label>
                <select id="status1" name="status1" class="form-select">
                    <option value="all" <?php echo e(isset($sstatus1) && $sstatus1=='all' || request('status')==null ? 'selected'
                        : ''); ?>>All
                    </option>
                    <option value="paid" <?php echo e(isset($sstatus1) && $sstatus1=='paid' ? 'selected' : ''); ?>>Paid</option>
                    <option value="unpaid" <?php echo e(isset($sstatus1) && $sstatus1=='unpaid' ? 'selected' : ''); ?>>Unpaid
                    </option>
                    <option value="partially_paid" <?php echo e(isset($sstatus1) && $sstatus1=='partially_paid' ? 'selected' : ''); ?>>Pending
                    </option>
                </select>
            </div>
            <div><button type="button" class="submit-btn btn btn-primary" data-action="search"
                    style="margin-top:30px;">Search</button>
                <button type="button" class="submit-btn btn btn-secondary ms-2" data-action="clear"
                    style="margin-top:30px;">Clear</button>
                <a
            href="<?php echo e(route('admin.PaymentManagement-index', array_merge(request()->all(), ['download' => 'pdf']))); ?>"
            class="btn btn-danger ms-2" style="margin-top:30px;">Download PDF</a>
            <a href="<?php echo e(route('admin.PaymentManagement-create')); ?>" class="btn btn-success" style="margin-top:30px;">Add New Payment</a>
            </div>

        </div>
        <div class="col-md-2">

        </div>
        <div class="col-md-4">

            
        </div>

        <div class="col-md-2">

        </div>


        <div class="col-md-4">



        </div>
    </form>
    <div class="col-md-12 align-self-end" style="margin-bottom: 10px;">


        

        
        
    </div>
    <div class="table-responsive">
        <table id="payment-table" class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>Driver Details</th>
                    <th>Driver Earning Amount</th>
                    <th>Commission Amount </th>
                    <th>Paid Amount </th>
                    <th>Balance Amount </th>
                    <th>Status </th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
      				<td><?php echo e(\Carbon\Carbon::parse($data->created_at)->format('d M Y') . ' - ' . $data->driver_code . '-' . $data->driver_name); ?></td>
                    <td>₹ <?php echo e(number_format($data->amount, 2)); ?></td>
                    <td>₹ <?php echo e(number_format($data->commission_amount, 2)); ?></td>
                    <td>₹ <?php echo e(number_format($data->paid_amount, 2)); ?></td>
                    <td>₹ <?php echo e(number_format($data->pending_amount, 2)); ?></td>
                    <td>
                        <?php if($data->payment_status == 0): ?>
                        <span class="badge bg-danger">Unpaid</span>
                        <?php elseif($data->payment_status == 1): ?>
                        <span class="badge bg-warning text-dark">Pending</span>
                        <?php elseif($data->payment_status == 2): ?>
                        <span class="badge bg-success">Paid</span>
                        <?php else: ?>
                        <span class="badge bg-secondary">Unknown</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="text-center text-muted">No data available for the selected filters.</td>
                </tr>
                <?php endif; ?>

            </tbody>
        </table>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script2'); ?>
<script>
    $(document).ready(function(){
        $('.submit-btn').click(function () {
        var actionType = $(this).data('action'); // Get button data-action value
        $('#action_type').val(actionType);       // Set hidden input value
        $('#myForm').submit();                   // Submit the form
    });


    $('#driver_name').select2({
    placeholder: "Select User Roles",
    allowClear: false,
    });



    $('#from_date').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        todayHighlight: true
    });

    $('#to_date').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        todayHighlight: true
    });

    // When from_date changes
    $('#from_date').on('changeDate', function () {
        const fromDate = $('#from_date').datepicker('getDate');
        const toDate = $('#to_date').datepicker('getDate');

        // Set the minimum selectable date for to_date
        $('#to_date').datepicker('setStartDate', fromDate);

        // If to_date is before from_date, update to_date to match from_date
        if (toDate && toDate < fromDate) {
            $('#to_date').datepicker('setDate', fromDate);
        }
    });

    // When to_date changes
    $('#to_date').on('changeDate', function () {
        const fromDate = $('#from_date').datepicker('getDate');
        const toDate = $('#to_date').datepicker('getDate');

        // If to_date is before from_date, update from_date to match to_date
        if (fromDate && toDate && toDate < fromDate) {
            $('#from_date').datepicker('setDate', toDate);
            $('#to_date').datepicker('setStartDate', toDate); // update min of to_date
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/vaigainammataxi.com/resources/views/admin/payment_management/list.blade.php ENDPATH**/ ?>